/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.datacard;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.data.BlockPosDim;
import com.lothrazar.cyclic.item.ItemBaseCyclic;
import com.lothrazar.cyclic.util.ChatUtil;
import com.lothrazar.cyclic.util.LevelWorldUtil;
import com.lothrazar.cyclic.util.TagDataUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EnderBucket
extends ItemBaseCyclic {
    private static final String NBT_SIDE = "side";
    private static final String NBT_DIM = "dim";

    public EnderBucket(Item.Properties properties) {
        super(properties);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        BlockPosDim dim = EnderBucket.getPosition(stack);
        if (dim != null) {
            tooltip.add((Component)new TranslatableComponent(dim.toString()).m_130940_(ChatFormatting.GRAY));
            if (flagIn.m_7050_() || Screen.m_96638_()) {
                String side = "S: " + dim.getSide().toString().toUpperCase();
                tooltip.add((Component)new TranslatableComponent(side).m_130940_(ChatFormatting.GRAY));
                String sideF = "F: " + dim.getSidePlayerFacing().toString().toUpperCase();
                tooltip.add((Component)new TranslatableComponent(sideF).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)new TranslatableComponent("H: " + dim.getHitVec().toString()).m_130940_(ChatFormatting.GRAY));
            }
        } else {
            TranslatableComponent t = new TranslatableComponent(this.m_5524_() + ".tooltip");
            t.m_130940_(ChatFormatting.GRAY);
            tooltip.add((Component)t);
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        BlockPos pos = context.m_8083_();
        Direction side = context.m_43719_();
        ItemStack held = player.m_21120_(hand);
        player.m_6674_(hand);
        TagDataUtil.setItemStackBlockPos(held, pos);
        held.m_41784_().m_128359_(NBT_DIM, LevelWorldUtil.dimensionToString(player.f_19853_));
        TagDataUtil.setItemStackNBTVal(held, NBT_SIDE, side.ordinal());
        TagDataUtil.setItemStackNBTVal(held, "sidefacing", player.m_6350_().ordinal());
        ChatUtil.sendStatusMessage(player, ChatUtil.lang("item.location.saved") + ChatUtil.blockPosToString(pos));
        Vec3 vec = context.m_43720_();
        held.m_41784_().m_128347_("hitx", vec.f_82479_ - (double)pos.m_123341_());
        held.m_41784_().m_128347_("hity", vec.f_82480_ - (double)pos.m_123342_());
        held.m_41784_().m_128347_("hitz", vec.f_82481_ - (double)pos.m_123343_());
        return InteractionResult.SUCCESS;
    }

    public static BlockPosDim getPosition(ItemStack item) {
        BlockPos pos = TagDataUtil.getItemStackBlockPos(item);
        if (pos == null) {
            return null;
        }
        CompoundTag tag = item.m_41784_();
        item.m_41786_();
        BlockPosDim dim = new BlockPosDim(pos, tag.m_128461_(NBT_DIM), tag);
        try {
            dim.setSidePlayerFacing(Direction.values()[tag.m_128451_("sidefacing")]);
            dim.setSide(Direction.values()[tag.m_128451_(NBT_SIDE)]);
            Vec3 vec = new Vec3(tag.m_128459_("hitx"), tag.m_128459_("hity"), tag.m_128459_("hitz"));
            dim.setHitVec(vec);
        }
        catch (Throwable e) {
            ModCyclic.LOGGER.error("SIde error in GPS", e);
        }
        return dim;
    }
}

